﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Data;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.Entities
{
    public class UserAccount : BusinessBaseClass
    {

        public UserAccount()
        { }

        public UserAccount(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UserAccountID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("UserAccountID"));
            UserName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UserName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("UserName"));
            UPassword = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UPassword")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("UPassword"));
            Email = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Email")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Email"));
            Salutation = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Salutation")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Salutation"));
            FirstName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("FirstName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("FirstName"));
            LastName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("LastName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("LastName"));
            Gender = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Gender")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Gender"));
            MobileNo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("MobileNo")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("MobileNo"));
            PhoneNo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PhoneNo")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PhoneNo"));
            DOB = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DOB")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("DOB"));
            Occupation = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Occupation")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Occupation"));
            Address1 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Address1")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Address1"));
            Address2 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Address2")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Address2"));
            City = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("City")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("City"));
            StateProvince = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("StateProvince")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("StateProvince"));
            Country = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Country")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Country"));
            PostalCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PostalCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PostalCode"));
            CustomerType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CustomerType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("CustomerType"));
            DiscountType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DiscountType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DiscountType"));
            DiscountValue = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DiscountValue")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("DiscountValue"));
            UserRoleType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UserRoleType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("UserRoleType"));
            IsApproved = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsApproved")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsApproved"));
            //IsSubscribed = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsSubscribed")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsSubscribed"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public string UserName { get; set; }

        public string UPassword { get; set; }

        public string Email { get; set; }

        public string Salutation { get; set; }

        public string FirstName { get; set; }

        public string LastName { get; set; }

        public string Gender { get; set; }

        public string MobileNo { get; set; }

        public string PhoneNo { get; set; }

        public DateTime DOB { get; set; }

        public string Occupation { get; set; }

        public string Address1 { get; set; }

        public string Address2 { get; set; }

        public string City { get; set; }

        public string StateProvince { get; set; }

        public string Country { get; set; }

        public string PostalCode { get; set; }

        public string CustomerType { get; set; }

        public string DiscountType { get; set; }

        public decimal DiscountValue { get; set; }

        public string UserRoleType { get; set; }

        public bool IsApproved { get; set; }

        public bool IsSubscribed { get; set; }

        public Guid AdminUserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }

        //public override bool IsDeleted { get; set; }
    }
}
